/*
 * Decompiled with CFR 0.152.
 */
package rtg;

import java.nio.file.Paths;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.world.DimensionType;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import rtg.RTGConfig;
import rtg.api.RTGAPI;
import rtg.api.util.PlateauUtil;
import rtg.client.GuiCustomizeWorldScreenRTG;
import rtg.event.EventHandlerCommon;
import rtg.init.BiomeInit;
import rtg.util.ModCompat;
import rtg.world.WorldTypeRTG;

@Mod(modid="rtg", name="Realistic Terrain Generation", version="6.1.0.0-snapshot.1", dependencies="required-after:forge@[14.23.5.2779,);required:rtgapi@[1.0.0,);after:abyssalcraft@[1.9.4.3,);after:biomesoplenty@[7.0.1.2399,);", guiFactory="rtg.RTGConfig$RTGGuiConfigFactory", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]")
public final class RTG {
    public static final String MOD_ID = "rtg";
    public static final String MOD_NAME = "Realistic Terrain Generation";
    public static final String MOD_VERSION = "6.1.0.0-snapshot.1";
    public static final String MCF_MINVER = "14.23.5.2779";
    public static final String MOD_DEPS = "after:abyssalcraft@[1.9.4.3,);after:biomesoplenty@[7.0.1.2399,);";
    private static final RTG instance = new RTG();
    private static boolean DISABLE_DECORATIONS;
    private static boolean DISABLE_SURFACES;
    @SidedProxy
    private static RTGProxy proxy;

    private RTG() {
    }

    @Mod.InstanceFactory
    public static RTG getInstance() {
        return instance;
    }

    public static RTGProxy getProxy() {
        return proxy;
    }

    @Mod.EventHandler
    public void initPre(FMLPreInitializationEvent event) {
        DISABLE_DECORATIONS = System.getProperties().containsKey("rtg.disableDecorations");
        DISABLE_SURFACES = System.getProperties().containsKey("rtg.disableSurfaces");
        RTGAPI.setConfigPath(Paths.get(event.getModConfigurationDirectory().getPath(), MOD_ID.toUpperCase()));
        RTGConfig.init(event);
        RTGAPI.addAllowedDimensionType(DimensionType.OVERWORLD);
        WorldTypeRTG.init();
        ModCompat.init();
        BiomeInit.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        EventHandlerCommon.init();
    }

    @Mod.EventHandler
    public void initPost(FMLPostInitializationEvent event) {
        BiomeInit.init();
        ModCompat.doBiomeCheck();
        PlateauUtil.init();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        RTGAPI.RTG_BIOMES.setLocked();
    }

    public static boolean decorationsDisable() {
        return DISABLE_DECORATIONS;
    }

    public static boolean surfacesDisabled() {
        return DISABLE_SURFACES;
    }

    public static interface RTGProxy {
        public void displayCustomizeWorldScreen(GuiCreateWorld var1);
    }

    public static class ServerProxy
    implements RTGProxy {
        @Override
        public void displayCustomizeWorldScreen(GuiCreateWorld guiCreateWorld) {
        }
    }

    public static final class ClientProxy
    implements RTGProxy {
        @Override
        public void displayCustomizeWorldScreen(GuiCreateWorld guiCreateWorld) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiCustomizeWorldScreenRTG((GuiScreen)guiCreateWorld, guiCreateWorld.field_146334_a));
        }
    }
}

